### **1. Overview of Angler Exploit Kit**

- **First Appearance**: Late 2013.
- **Key Features**:
    - One of the **most aggressive and prolific exploit kits**.
    - Targets vulnerabilities in **HTML, JavaScript, Flash, Silverlight, Java**, etc.
- **Impact**:
    - In 2015, Angler accounted for **40% of observed cyberattacks** (Cisco Midyear Security Report).
    - Primarily used to deliver **ransomware payloads**.

---

### **2. How Angler Operates**

- **High-Level Workflow**:
    
    1. Victim visits a **compromised legitimate website**.
    2. Website contains **malicious obfuscated scripts or iFrames** that redirect to the Angler landing page.
    3. Landing page scans the victim's machine for vulnerabilities.
    4. Delivers exploit targeting the identified vulnerabilities.
    5. Deploys the **malware payload** (e.g., ransomware like Cryptowall).
    6. **Malware CnC traffic** occurs between the victim’s system and the attacker’s Command and Control (CnC) servers.
- **Redirection Process**:
    
    - May involve **multiple stages** of redirection through "gates" (intermediate malicious sites).
    - Example URL structures:
        - Gate: `/some_random_words_here/154920479320`.
        - Landing page: `/L8Vz9fnAJQ-NIIEeBal7h7QTEL5YpvcKfrOMuBGcE7sOA4Xt.php`.

---

### **3. Ransomware Payload and Infection**

- **Payload**: Primarily **ransomware** like Cryptowall.
    - Encrypts the victim’s files.
    - Demands payment for decryption keys.
- **How Cryptowall Operates**:
    - Sends an HTTP POST request with **encrypted messages** containing:
        - Unique campaign ID.
        - 32-bit infection identifier.
        - System-specific information (computer name, OS version, disk serial number, etc.).
    - CnC server responds with an **RSA-2048 public key** to encrypt files.
    - Cryptowall recursively encrypts the file system.
- Infection completes in **seconds**, from the victim’s first click to full compromise.

---

### **4. Features and Sophistication**

- **Evasion Tactics**:
    - Rapidly changes URL structures for landing pages.
    - Low-frequency use of compromised referrers (most referrers used <10 times).
- **Infrastructure**:
    - Includes **proxy servers**, **exploit servers**, and **status servers**:
        - **Proxy Servers**: Interact directly with victims and redirect to exploit servers.
        - **Exploit Servers**: Deliver exploit code through proxy servers.
        - **Status Servers**: Monitor infrastructure and log activity.
    - Redundancy ensures robustness: Taking down a proxy server doesn’t affect the exploit server.

---

### **5. Observations by Talos Intelligence Group**

- **Compromised Web Servers**:
    - Majority were **WordPress-based servers**.
    - Included hundreds of **news, real estate, and popular culture websites**, along with small, random sites.
- **Scale of Operations**:
    - Single status server monitored **147 proxy servers**.
    - Estimated monthly revenue of **$3 million** per instance, with annual revenue exceeding **$30 million**.
    - A single proxy server compromised ~3,600 users per day; 147 servers compromised ~529,000 victims in a month.

---

### **6. Decline of Angler Exploit Kit**

- **Detection Efforts**:
    - **Snort IPS Rules**: Developed to detect and block communication between proxy, exploit, and health servers.
    - Resulted in a significant drop in Angler activity.
- **Shift in Threat Landscape**:
    - Threat actors moved on to other exploit kits.
    - Exploit kits remain a dominant method for ransomware distribution.

---

### **7. Key Takeaways**

- Angler demonstrated the **sophistication and scale** of modern exploit kits.
- Its modular infrastructure made it **resilient** to takedowns.
- Threat actors' ability to quickly adapt and move to new tools ensures exploit kits will remain a significant threat.
- Exploit kits and ransomware are **interlinked**, driving substantial financial gains for attackers.